 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 22/10/2012
 *
 *******************************************************************/

 #ifndef __QUEUE0_H
 #define __QUEUE0_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class Queue0 : public Atomic
 {
   public:
	       Queue0( const std::string &name = "Queue0" );	//Default constructor
	       virtual std::string className() const { return "Queue0"; }
	       ~Queue0();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In,&Req,&InCoMP1,&InCoMP6;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class Queue0

 #endif   //__QUEUE0_H
